---  00 dblog Python
CREATE OR REPLACE FUNCTION tlog.dblog__Logfile__exists(a_date date DEFAULT today(), a_pid integer DEFAULT pg_backend_pid(), a_database varchar default current_database()) RETURNS boolean AS
$$
  import os

  _plan = plpy.prepare("SELECT tlog.dblog__Logfile__full_path__Get($1::date, $2::integer, $3::varchar) as filename", ["date","integer","varchar"])
  _ret = plpy.execute(_plan, [a_date, a_pid, a_database])
  _filename = _ret[0]["filename"]

  if os.path.exists(_filename):
    return True
  else:
    return False
$$ LANGUAGE plpython3u;

--------------------------------------------------------------------------------
-- delete a csvlogfile from disk
CREATE OR REPLACE FUNCTION tlog.dblog__Logfile__delete(a_date date DEFAULT today(), a_pid integer DEFAULT pg_backend_pid(), a_database varchar default current_database()) RETURNS void AS
$$
  import os

  _plan = plpy.prepare("SELECT tlog.dblog__Logfile__full_path__Get($1::date, $2::integer, $3::varchar) as filename", ["date","integer","varchar"])
  _ret = plpy.execute(_plan, [a_date, a_pid, a_database])
  _filename = _ret[0]["filename"]

  if os.path.exists(_filename):
    os.remove(_filename)
$$ LANGUAGE plpython3u;


--------------------------------------------------------------------------------
-- manually import csvlogfiles into tlog.dblog
CREATE OR REPLACE FUNCTION tlog.dblog__Logfiles__import(currentsession boolean, othersessions boolean, thisday boolean, olderthanthisday boolean) RETURNS void AS
$$
  import glob
  import datetime

  _plan = plpy.prepare("SELECT tlog.dblog__Logfile__import($1::date, $2::integer, $3::varchar) as filename", ["date","integer","varchar"])
  _ret = plpy.execute("SELECT pg_backend_pid() as pid, current_database() as db, tlog.dblog__Logfile__dir_name__Get() as logdir")

  _current_pid = _ret[0]["pid"]
  _current_db = _ret[0]["db"]
  _LogDir = _ret[0]["logdir"] + '/'
  _LenDir = len(_LogDir)

  for _file in glob.glob(_LogDir + "csvlog.*.*.*.csv"):
    _filename = _file[_LenDir:]
    _parts = _filename.split(".")
    _partscount = len(_parts)
    _plan_notice = plpy.prepare("SELECT ($1::varchar);", ["varchar"])
    _message = "tlog.dblog__Logfiles__import: " + _filename
    plpy.execute(_plan_notice, [_message])
    if ((_partscount == 5) and (_parts[0] == 'csvlog') and (_parts[4] == 'csv')):
      _database = _parts[1]
      try:
        _pid = int(_parts[3])
      except Exception as _E:
        _pid = 0

      try:
        _date = datetime.datetime.strptime(_parts[2], '%Y%m%d')
      except Exception as _E:
        _pid = 0

      _doimport = False

      if (currentsession and (_pid == _current_pid)):
        _doimport = True
      if (othersessions and (_pid != _current_pid)):
        _doimport = True

      _diff = datetime.datetime.now() - _date
      if (thisday and (_diff.days == 0)):
        _doimport = True
      if (olderthanthisday and (_diff.days > 0)):
        _doimport = True

      if ((_pid > 0) and _doimport and (_database == _current_db)):
        _ret = plpy.execute(_plan, [_date, _pid, _database])
$$ LANGUAGE plpython3u;

--------------------------------------------------------------------------------
-- returns the existing importlogfiles without showing actual filenames
CREATE OR REPLACE FUNCTION tlog.dblog__Logfiles__import__log_line__create() RETURNS SETOF tlog.dblogfiles_imported AS
$$
  import glob
  import datetime

  _ret = plpy.execute("SELECT pg_backend_pid() as pid, current_database() as db, tlog.dblog__Logfile__dir_name__Get() as logdir")

  _current_pid = _ret[0]["pid"]
  _current_db = _ret[0]["db"]
  _LogDir = _ret[0]["logdir"] + '/'
  _LenDir = len(_LogDir)

  for _file in glob.glob(_LogDir + "csvlog.*.*.*.csv"):
    _filename = _file[_LenDir:]
    _parts = _filename.split(".")
    _partscount = len(_parts)
    _plan_notice = plpy.prepare("SELECT tlog.dblog__raisenotice($1::varchar);", ["varchar"])
    _message = "tlog.dblog__Logfiles__import__log_line__create: " + _filename
    plpy.execute(_plan_notice, [_message])
    if ((_partscount == 5) and (_parts[0] == 'csvlog') and (_parts[4] == 'csv')):
      _database = _parts[1]
      try:
        _pid = int(_parts[3])
      except Exception as _E:
        _pid = 0

      try:
        _date = datetime.datetime.strptime(_parts[2], '%Y%m%d')
      except Exception as _E:
        _pid = 0

      if ((_pid > 0)):
        yield(_date, _database, _pid)
$$ LANGUAGE plpython3u;

--------------------------------------------------------------------------------
-- write a line to the csvlogfile
--   the encoding of the file-open needs to be the same as the default db-encoding
--   this should be always utf-8, considering the stand of things at moment of coding
CREATE OR REPLACE FUNCTION tlog.dblog__Logfile__log_line__write( csvline varchar,  _logfilename varchar = tlog.dblog__Logfile__full_path__Get() ) RETURNS void AS
$$
  import os

  with open(_logfilename, 'a', encoding='utf8') as fd:
    fd.write(csvline + f'\n')
    
$$ LANGUAGE plpython3u;
---
